/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.entity.MonkeyEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class MonkeyModel<T extends MonkeyEntity>
extends AdvancedEntityModel<T> {
    private final ModelPart Body;
    private final ModelPart BodyFront;
    private final ModelPart Head;
    private final ModelPart Tail;
    private final ModelPart Tail2;
    private final ModelPart Tail3;
    private final ModelPart FrontRightLegTop;
    private final ModelPart FrontRightLegBottom;
    private final ModelPart FrontLeftLegTop;
    private final ModelPart FrontLeftLegBottom;
    private final ModelPart BackRightLegTop;
    private final ModelPart BackLeftLegTop;

    public MonkeyModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.BodyFront = this.Body.m_171324_("BodyFront");
        this.Head = this.BodyFront.m_171324_("Head");
        this.Tail = this.Body.m_171324_("Tail");
        this.Tail2 = this.Tail.m_171324_("Tail2");
        this.Tail3 = this.Tail2.m_171324_("Tail3");
        this.FrontRightLegTop = this.BodyFront.m_171324_("FrontRightLegTop");
        this.FrontRightLegBottom = this.FrontRightLegTop.m_171324_("FrontRightLegBottom");
        this.FrontLeftLegTop = this.BodyFront.m_171324_("FrontLeftLegTop");
        this.FrontLeftLegBottom = this.FrontLeftLegTop.m_171324_("FrontLeftLegBottom");
        this.BackRightLegTop = this.Body.m_171324_("BackRightLegTop");
        this.BackLeftLegTop = this.Body.m_171324_("BackLeftLegTop");
    }

    public void setupAnim(MonkeyEntity monkey, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (monkey.isPartying()) {
            this.setPartyAngles();
            this.defaultWalking1(this.BackLeftLegTop, 67.5f, limbSwing, limbSwingAmount);
            this.defaultWalking2(this.BackRightLegTop, 67.5f, limbSwing, limbSwingAmount);
            this.FrontLeftLegTop.f_104205_ = -0.6108f + Mth.m_14089_((float)(ageInTicks * 0.7f)) * 0.2617f;
            this.FrontRightLegTop.f_104205_ = 0.6108f + Mth.m_14089_((float)(ageInTicks * 0.7f + (float)Math.PI)) * 0.2617f;
            this.Head.f_104203_ = 1.3963f + Mth.m_14089_((float)(ageInTicks * 0.7f + (float)Math.PI)) * 0.1745f;
        } else {
            this.setDefaultAngles();
            this.defaultWalking1(this.FrontRightLegTop, 10.0f, limbSwing, limbSwingAmount);
            this.defaultWalking2(this.FrontLeftLegTop, 10.0f, limbSwing, limbSwingAmount);
            this.defaultWalking1(this.BackLeftLegTop, -12.5f, limbSwing, limbSwingAmount);
            this.defaultWalking2(this.BackRightLegTop, -12.5f, limbSwing, limbSwingAmount);
            this.defaultHeadMovement(this.Head, 2.5f, 0.0f, headPitch, netHeadYaw);
            this.Tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.3f * limbSwingAmount;
            this.Tail2.f_104204_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.7f * limbSwingAmount;
        }
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            matrixStackIn.m_85841_(0.5f, 0.5f, 0.5f);
            matrixStackIn.m_85837_(0.0, 1.5, 0.0);
        }
        this.Body.m_104301_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn);
    }

    private void setDefaultAngles() {
        this.Body.m_104227_(0.0f, 16.8264f, 3.7609f);
        this.setRotationAngle(this.Body, -0.0873f, 0.0f, 0.0f);
        this.Head.m_104227_(0.0f, -0.2655f, -4.271f);
        this.setRotationAngle(this.Head, 0.0f, 0.0f, 0.0f);
        this.setRotationAngle(this.FrontRightLegTop, 0.1745f, 0.0f, 0.0f);
        this.FrontRightLegBottom.m_104227_(0.0f, 2.8619f, -0.1854f);
        this.setRotationAngle(this.FrontRightLegBottom, -0.1745f, 0.0f, 0.0f);
        this.setRotationAngle(this.FrontLeftLegTop, 0.1745f, 0.0f, 0.0f);
        this.FrontLeftLegBottom.m_104227_(0.0f, 2.8865f, -0.1898f);
        this.setRotationAngle(this.FrontLeftLegBottom, -0.1745f, 0.0f, 0.0f);
        this.setRotationAngle(this.BackRightLegTop, -0.2182f, 0.0f, 0.0f);
        this.setRotationAngle(this.BackLeftLegTop, -0.2182f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail, 0.6545f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail2, 0.576f, 0.0f, 0.0f);
        this.Tail3.m_104227_(0.0f, -0.246f, 3.5488f);
        this.setRotationAngle(this.Tail3, -0.9599f, 0.0f, 0.0f);
    }

    private void setPartyAngles() {
        this.Body.m_104227_(0.0f, 16.8264f, 0.7609f);
        this.setRotationAngle(this.Body, -1.4835f, 0.0f, 0.0f);
        this.Head.m_104227_(0.0f, -1.9627f, -5.5457f);
        this.setRotationAngle(this.Head, 1.3963f, 0.0f, 0.0f);
        this.setRotationAngle(this.FrontRightLegTop, 0.1745f, 0.0f, 0.4363f);
        this.FrontRightLegBottom.m_104227_(-0.425f, 2.2369f, -0.1854f);
        this.setRotationAngle(this.FrontRightLegBottom, 0.0f, 0.0f, -1.1345f);
        this.setRotationAngle(this.FrontLeftLegTop, 0.1745f, 0.0f, -0.4363f);
        this.FrontLeftLegBottom.m_104227_(0.4f, 2.2365f, -0.1898f);
        this.setRotationAngle(this.FrontLeftLegBottom, 0.0f, 0.0f, 1.1345f);
        this.setRotationAngle(this.BackRightLegTop, 1.1781f, 0.0f, 0.0f);
        this.setRotationAngle(this.BackLeftLegTop, 1.1781f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail, 0.3491f, 0.0f, 0.0f);
        this.setRotationAngle(this.Tail2, 0.4451f, 0.0f, 0.0f);
        this.Tail3.m_104227_(0.0f, 0.0751f, 3.7487f);
        this.setRotationAngle(this.Tail3, 0.6545f, 0.0f, 0.0f);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 14).m_171488_(-3.0f, -2.9948f, -3.2964f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)16.8264f, (float)3.7609f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition BodyFront = Body.m_171599_("BodyFront", CubeListBuilder.m_171558_().m_171514_(0, 23).m_171488_(-3.0f, -1.8282f, -5.0129f, 6.0f, 4.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.174f, (float)-3.1568f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition Head = BodyFront.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171488_(-2.5f, -3.9712f, -4.0871f, 5.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-0.2655f, (float)-4.271f));
        PartDefinition MouthTop = Head.m_171599_("MouthTop", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.5f, -0.975f, -2.0f, 3.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.022f, (float)-3.3425f, (float)0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition MouthBottom = Head.m_171599_("MouthBottom", CubeListBuilder.m_171558_().m_171514_(19, 8).m_171488_(-1.5f, -0.475f, -2.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.2191f, (float)-3.1611f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition EarRight = Head.m_171599_("EarRight", CubeListBuilder.m_171558_().m_171514_(28, 21).m_171488_(-0.5f, -0.95f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.5f, (float)-2.1589f, (float)-2.0536f));
        PartDefinition EarLeft = Head.m_171599_("EarLeft", CubeListBuilder.m_171558_().m_171514_(28, 21).m_171480_().m_171488_(-0.5f, -0.95f, -0.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.5f, (float)-2.1589f, (float)-2.0536f));
        PartDefinition FrontRightLegTop = BodyFront.m_171599_("FrontRightLegTop", CubeListBuilder.m_171558_().m_171514_(15, 0).m_171480_().m_171488_(-1.0f, -0.9462f, -1.1566f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.5f, (float)0.8968f, (float)-3.0129f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition FrontRightLegBottom = FrontRightLegTop.m_171599_("FrontRightLegBottom", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -0.175f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(24, 30).m_171488_(-1.0f, 3.825f, -2.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.8619f, (float)-0.1854f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition FrontLeftLegTop = BodyFront.m_171599_("FrontLeftLegTop", CubeListBuilder.m_171558_().m_171514_(15, 0).m_171488_(-1.0f, -0.9462f, -1.1566f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)0.8968f, (float)-3.0129f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition FrontLeftLegBottom = FrontLeftLegTop.m_171599_("FrontLeftLegBottom", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171480_().m_171488_(-1.0f, -0.2f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(24, 30).m_171480_().m_171488_(-1.0f, 3.8f, -2.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)2.8865f, (float)-0.1898f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition BackRightLegTop = Body.m_171599_("BackRightLegTop", CubeListBuilder.m_171558_().m_171514_(15, 0).m_171480_().m_171488_(-1.0f, -1.2262f, -0.9925f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-2.5f, (float)-0.075f, (float)-0.0033f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition BackRightLegBottom = BackRightLegTop.m_171599_("BackRightLegBottom", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -0.25f, -0.975f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(24, 30).m_171488_(-1.0f, 3.75f, -1.975f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)2.6048f, (float)0.0064f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition BackLeftLegTop = Body.m_171599_("BackLeftLegTop", CubeListBuilder.m_171558_().m_171514_(15, 0).m_171488_(-1.0f, -1.3012f, -0.9925f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.5f, (float)0.0f, (float)0.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition BackLeftLegBottom = BackLeftLegTop.m_171599_("BackLeftLegBottom", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171480_().m_171488_(-1.0f, -0.325f, -0.875f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(24, 30).m_171480_().m_171488_(-1.0f, 3.675f, -1.875f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)2.6273f, (float)-0.0651f, (float)0.3054f, (float)0.0f, (float)0.0f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(18, 20).m_171488_(-1.0f, -0.95f, 0.0f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-1.7519f, (float)0.3378f, (float)0.6545f, (float)0.0f, (float)0.0f));
        PartDefinition Tail2 = Tail.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(22, 14).m_171488_(-0.5f, -0.575f, 0.0f, 1.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.0568f, (float)4.3282f, (float)0.576f, (float)0.0f, (float)0.0f));
        PartDefinition Tail3 = Tail2.m_171599_("Tail3", CubeListBuilder.m_171558_().m_171514_(18, 13).m_171488_(-0.5f, -0.575f, 0.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-0.246f, (float)3.5488f, (float)-0.9599f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)32, (int)32);
    }
}

